/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.browser.internal;

import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.jdesktop.jdic.browser.BrowserEngineManager;
import org.jdesktop.jdic.browser.IBrowserEngine;
import org.jdesktop.jdic.browser.IWebBrowser;
import org.jdesktop.jdic.browser.WebBrowserEvent;
import org.jdesktop.jdic.browser.internal.MsgClient;
import org.jdesktop.jdic.browser.internal.NativeEventData;
import org.jdesktop.jdic.browser.internal.WebBrowserUtil;
import org.jdesktop.jdic.init.JdicInitException;
import org.jdesktop.jdic.init.JdicManager;

public class NativeEventThread
extends Thread {
    private Vector webBrowsers = new Vector();
    private Vector nativeEvents = new Vector();
    private Process nativeBrowser;
    private boolean eventRetBool;
    private String eventRetString;
    private MsgClient messenger = null;
    private IBrowserEngine engine = null;

    public NativeEventThread() {
        super("EventThread");
        WebBrowserUtil.trace("Envent Thread new once!");
    }

    public void attachWebBrowser(IWebBrowser iWebBrowser) {
        int n2 = iWebBrowser.getInstanceNum();
        if (n2 >= this.webBrowsers.size()) {
            this.webBrowsers.setSize(n2 + 1);
        }
        this.webBrowsers.set(n2, iWebBrowser);
    }

    public void run() {
        WebBrowserUtil.trace("Envent Thread run once!");
        try {
            String string;
            this.messenger = new MsgClient();
            this.engine = BrowserEngineManager.instance().getActiveEngine();
            try {
                this.engine.initialize();
            }
            catch (JdicInitException jdicInitException) {
                jdicInitException.printStackTrace();
                return;
            }
            if (this.engine.getEmbeddedBinaryName() == null) {
                this.setBrowsersInitFailReason("The embedded browser binary is not set.");
                WebBrowserUtil.error("The embedded browser binary is not set, system exit.");
                return;
            }
            String string2 = System.getProperty("java.vm.vendor");
            if (this.engine.getEmbeddedBinaryName().endsWith("IeEmbed.exe") && string2.startsWith("Sun")) {
                WebBrowserUtil.nativeSetEnvironment();
            }
            final String string3 = new File(string = JdicManager.getManager().getBinaryPath() + File.separator + this.engine.getEmbeddedBinaryName()).exists() ? string : this.engine.getEmbeddedBinaryName();
            WebBrowserUtil.trace("Executing " + string3 + " -port=" + this.messenger.getPort());
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    NativeEventThread.this.nativeBrowser = Runtime.getRuntime().exec(new String[]{string3, "-port=" + NativeEventThread.this.messenger.getPort()});
                    new StreamGobbler(NativeEventThread.this.nativeBrowser.getErrorStream()).start();
                    new StreamGobbler(NativeEventThread.this.nativeBrowser.getInputStream()).start();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.setBrowsersInitFailReason("Can't find the native embedded browser.");
            System.out.println("Can't execute the native embedded browser. Error message: " + privilegedActionException.getCause().getMessage());
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    NativeEventThread.this.messenger.connect();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            System.out.println("Can't connect to the native embedded browser. Error message: " + privilegedActionException.getCause().getMessage());
            this.setBrowsersInitFailReason("Can't connect to the native embedded browser.");
            return;
        }
        while (true) {
            try {
                Thread.sleep(1L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                int n2 = this.nativeBrowser.exitValue();
                WebBrowserUtil.trace("Native embedded browser died.");
                return;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                try {
                    this.processEventsFromJava();
                }
                catch (Exception exception) {
                    WebBrowserUtil.trace("Exception occured when processEvent: " + exception.getMessage());
                    return;
                }
                try {
                    this.messenger.portListening();
                    this.processMessageFromNative(this.messenger.getMessage());
                }
                catch (Exception exception) {
                    WebBrowserUtil.trace("Exception occured when portListening: " + exception.getMessage());
                    return;
                }
            }
        }
    }

    private IWebBrowser getWebBrowserFromInstance(int n2) {
        try {
            return (IWebBrowser)this.webBrowsers.get(n2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWebBrowser(int n2) {
        IWebBrowser iWebBrowser = this.getWebBrowserFromInstance(n2);
        if (null != iWebBrowser) {
            IWebBrowser iWebBrowser2 = iWebBrowser;
            synchronized (iWebBrowser2) {
                iWebBrowser.notify();
            }
        }
    }

    private void processEventsFromJava() {
        int n2 = this.nativeEvents.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            NativeEventData nativeEventData = (NativeEventData)this.nativeEvents.get(i2);
            if (!this.processEventFromJava(nativeEventData)) continue;
            this.nativeEvents.removeElementAt(i2);
            break;
        }
    }

    private boolean processEventFromJava(NativeEventData nativeEventData) {
        IWebBrowser iWebBrowser = this.getWebBrowserFromInstance(nativeEventData.instance);
        if (null == iWebBrowser) {
            return true;
        }
        if (!iWebBrowser.isInitialized() && nativeEventData.type != 0 && nativeEventData.type != 1) {
            return false;
        }
        WebBrowserUtil.trace("Process event to native browser: " + nativeEventData.instance + ", " + nativeEventData.type + ", ");
        String string = nativeEventData.instance + "," + nativeEventData.type + ",";
        switch (nativeEventData.type) {
            case 0: 
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                this.messenger.sendMessage(string);
                break;
            }
            case 3: {
                this.messenger.sendMessage(string);
                break;
            }
            case 1: {
                int n2 = iWebBrowser.getNativeWindow();
                if (0 == n2) {
                    WebBrowserUtil.trace("Can't get the JAWT native window handler.");
                    break;
                }
                string = string + n2;
                this.messenger.sendMessage(string);
                break;
            }
            case 4: {
                string = string + nativeEventData.rectValue.x + "," + nativeEventData.rectValue.y + "," + nativeEventData.rectValue.width + "," + nativeEventData.rectValue.height;
                this.messenger.sendMessage(string);
                break;
            }
            case 5: 
            case 6: 
            case 16: 
            case 17: {
                string = string + nativeEventData.stringValue;
                this.messenger.sendMessage(string);
            }
        }
        return true;
    }

    public static NativeEventData parseMessageString(String string) {
        if (null == string || 0 == string.length()) {
            return null;
        }
        int n2 = -1;
        String string2 = null;
        int n3 = string.indexOf(",", 0);
        int n4 = Integer.parseInt(string.substring(0, n3));
        int n5 = string.indexOf(",", n3 + 1);
        if (n5 < 0) {
            n2 = Integer.parseInt(string.substring(n3 + 1));
        } else {
            n2 = Integer.parseInt(string.substring(n3 + 1, n5));
            if (n5 + 1 < string.length()) {
                string2 = string.substring(n5 + 1);
            }
        }
        return new NativeEventData(n4, n2, string2);
    }

    private void processMessageFromNative(String string) {
        NativeEventData nativeEventData = NativeEventThread.parseMessageString(string);
        if (nativeEventData == null) {
            return;
        }
        WebBrowserUtil.trace("Process event from native browser: " + nativeEventData.instance + ", " + nativeEventData.type + ", " + nativeEventData.stringValue);
        if (3041 == nativeEventData.type) {
            this.setBrowsersInitFailReason(nativeEventData.stringValue);
            WebBrowserUtil.error(nativeEventData.stringValue);
            return;
        }
        if (nativeEventData.instance < 0) {
            return;
        }
        final IWebBrowser iWebBrowser = this.getWebBrowserFromInstance(nativeEventData.instance);
        if (null == iWebBrowser) {
            return;
        }
        if (3007 == nativeEventData.type && iWebBrowser.isSynchronize()) {
            this.notifyWebBrowser(nativeEventData.instance);
            return;
        }
        if (3021 == nativeEventData.type || 3061 == nativeEventData.type || 3063 == nativeEventData.type || 3044 == nativeEventData.type) {
            this.eventRetString = nativeEventData.stringValue;
            this.notifyWebBrowser(nativeEventData.instance);
            return;
        }
        if (3042 == nativeEventData.type) {
            iWebBrowser.setInitialized(true);
            iWebBrowser.setInitFailureMessage("");
        }
        final WebBrowserEvent webBrowserEvent = new WebBrowserEvent(iWebBrowser, nativeEventData.type, nativeEventData.stringValue);
        Runnable runnable = new Runnable(){

            public void run() {
                iWebBrowser.dispatchWebBrowserEvent(webBrowserEvent);
            }
        };
        try {
            SwingUtilities.invokeLater(runnable);
        }
        catch (Exception exception) {
            WebBrowserUtil.trace("Exception occured when invokeLater. Error message: " + exception.getMessage());
        }
    }

    public synchronized void fireNativeEvent(int n2, int n3) {
        this.nativeEvents.addElement(new NativeEventData(n2, n3));
    }

    public synchronized void fireNativeEvent(int n2, int n3, Rectangle rectangle) {
        this.nativeEvents.addElement(new NativeEventData(n2, n3, rectangle));
    }

    public synchronized void fireNativeEvent(int n2, int n3, String string) {
        this.nativeEvents.addElement(new NativeEventData(n2, n3, string));
    }

    public void setBrowsersInitFailReason(String string) {
        ((IWebBrowser)this.webBrowsers.elementAt(0)).setInitFailureMessage(string);
    }

    public String getEventRetString() {
        return this.eventRetString;
    }

    public MsgClient getMessenger() {
        return this.messenger;
    }

    class StreamGobbler
    extends Thread {
        InputStream is;

        StreamGobbler(InputStream inputStream) {
            this.is = inputStream;
        }

        public void run() {
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(this.is);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    System.out.println("+++ Ctrace: " + string);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

